package de.schereSteinPapier.domain;

import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;

/**
 * A builder which allows to create a Demo game.
 */
public interface SSPGameBuilder extends GameBuilder {

    /**
     * Creates an {@link SSPPlayerBuilder} which allows to create and add a player to the game together with her
     * strategy.
     */
    SSPPlayerBuilder createPlayerBuilder();

    /**
     * Adds a player and the corresponding strategy.
     *
     * @param player   The player.
     * @param strategy The player's strategy.
     * @throws GameException if adding the player is not allowed by the rules of the game.
     */
    SSPGameBuilder addPlayer(SSPPlayer player, SSPStrategy strategy) throws GameException;

    /**
     * Changes the {@link ObserverFactoryProvider}.
     *
     * @param newObserverFactoryProvider The new {@link ObserverFactoryProvider}.
     * @return {@code this}
     */
    SSPGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider);

    @Override
    SSPGame build(int id) throws GameException, InterruptedException;

}
