package de.schereSteinPapier.moves.impl;

import de.schereSteinPapier.moves.SSPMove;

/**
 * Represents a move allowed by the rules of the game.
 * <p>
 * The purpose of this class is solely to be able to check whether a {@link SSPMove} implementation is allowed by the
 * rules of the game. As this class is not exported, custom strategies are unable to create {@link DSSPMove} objects
 * that inherit from this class, so custom moves can be distinguished from possible moves easily.
 */
public abstract class AbstractSSPMove implements SSPMove {

    /**
     * Protected constructor.
     */
    protected AbstractSSPMove() {
        // nothing to do
    }
}
