package de.schereSteinPapier.moves.impl;

import de.schereSteinPapier.moves.SSPMove;
import de.schereSteinPapier.moves.factory.SSPMoveFactory;

/**
 * Implements {@link SSPMoveFactory}.
 */
public class SSPDefaultMoveFactory implements SSPMoveFactory {

    @Override
    public SSPMove createSchereMove() {
        return new SSPSchereMove();
    }

    @Override
    public SSPMove createSteinMove() {
        return new SSPSteinMove();
    }
    
    @Override
    public SSPMove createPapierMove() {
        return new SSPPapierMove();
    }
}
