/*
 * Decompiled with CFR 0.152.
 */
package de.schereSteinPapier.domain.impl;

import de.fhdw.gaming.core.domain.AbstractPlayer;
import de.fhdw.gaming.core.domain.Player;
import de.schereSteinPapier.domain.SSPPlayer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class SSPPlayerImpl
extends AbstractPlayer<SSPPlayer>
implements SSPPlayer {
    private final Map<String, Map<String, Double>> possibleOutcomes;
    private Optional<String> answer;

    SSPPlayerImpl(String name, Map<String, Map<String, Double>> possibleOutcomes) {
        super(name);
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<String, Map<String, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
        this.answer = Optional.empty();
    }

    SSPPlayerImpl(SSPPlayer source) {
        super((Player)source);
        this.possibleOutcomes = source.getPossibleOutcomes();
        this.answer = source.getAnswer();
    }

    public String toString() {
        return String.format("SSP_Player[name=%s, state=%s, outcome=%s, answer=%s]", this.getName(), this.getState(), this.getOutcome(), this.answer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SSPPlayerImpl) {
            SSPPlayerImpl other = (SSPPlayerImpl)obj;
            return super.equals(obj) && this.answer.equals(other.answer);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.answer.hashCode();
    }

    @Override
    public Map<String, Map<String, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    @Override
    public Optional<String> getAnswer() {
        return this.answer;
    }

    @Override
    public void setAnswer(String newAnswer) {
        if (this.answer.isPresent()) {
            throw new IllegalStateException(String.format("Player %s tried to change her answer.", this.getName()));
        }
        this.answer = Optional.of(newAnswer);
    }

    public SSPPlayerImpl deepCopy() {
        return new SSPPlayerImpl(this);
    }
}

