package de.fhdw.gaming.ipspiel22.vierGewinnt.gui.impl;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGStrategy;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.VierGewinntBoardEventProvider;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.event.VierGewinntBoardEventVisitor;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.event.VierGewinntMakeMoveBoardEvent;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.VGMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.factory.VGMoveFactory;

/**
 * Implements {@link VGStrategy} by asking the user for a move.
 */
public final class VierGewinntInteractiveStrategy implements VGStrategy {

    /**
     * The factory for creating connect-4 moves.
     */
    private final VGMoveFactory moveFactory;

    /**
     * Creates a {@link VierGewinntInteractiveStrategy}.
     * 
     * @param moveFactory The factory for creating connect-4 moves.
     */
    VierGewinntInteractiveStrategy(final VGMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<VGMove> computeNextMove(final int gameId, final VGPlayer player, final VGState state)
            throws GameException {
        final Optional<VierGewinntBoardEventProvider> provider = VierGewinntGuiOberserverImpl.getEventProvider(gameId);
        if (provider.isEmpty()) {
            return Optional.empty();
        }

        final AtomicReference<VGMove> move = new AtomicReference<>();
        provider.get().waitForEvent(player, state).accept(new VierGewinntBoardEventVisitor() {

            @Override
            public void handleMakeMove(final VierGewinntMakeMoveBoardEvent event) {
                move.setPlain(VierGewinntInteractiveStrategy.this.moveFactory
                        .createTokenMove(player.isUsingRedChips(), event.getFieldPosition()));
            }

        });

        return Optional.ofNullable(move.getPlain());
    }

    @Override
    public String toString() {
        return VierGewinntInteractiveStrategy.class.getSimpleName();
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public void abortRequested(final int gameId) {
        final Optional<VierGewinntBoardEventProvider> provider = VierGewinntGuiOberserverImpl.getEventProvider(gameId);
        if (!provider.isEmpty()) {
            provider.get().cancelWaiting();
        }
    }
}
