/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl;

import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGAnswerEnum;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGBoard;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGField;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGFieldState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPosition;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl.VGFieldImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class VGBoardImpl
implements VGBoard {
    private static final int BOARD_COLUMNS = 7;
    private static final int BOARD_ROWS = 6;
    private final List<List<VGFieldImpl>> fields;
    private final Map<VGFieldState, Map<VGPosition, VGFieldImpl>> fieldsByState;

    public VGBoardImpl() throws IllegalArgumentException {
        int rows = 6;
        int columns = 7;
        this.fieldsByState = new LinkedHashMap<VGFieldState, Map<VGPosition, VGFieldImpl>>();
        LinkedHashMap<VGPosition, VGFieldImpl> emptyFields = new LinkedHashMap<VGPosition, VGFieldImpl>();
        this.fieldsByState.put(VGFieldState.EMPTY, emptyFields);
        this.fieldsByState.put(VGFieldState.RED, new LinkedHashMap());
        this.fieldsByState.put(VGFieldState.YELLOW, new LinkedHashMap());
        this.fields = new ArrayList<List<VGFieldImpl>>(7);
        for (int columnIndex = 0; columnIndex < 7; ++columnIndex) {
            ArrayList<VGFieldImpl> column = new ArrayList<VGFieldImpl>(6);
            for (int rowIndex = 0; rowIndex < 6; ++rowIndex) {
                VGPosition position = VGPosition.of(columnIndex, rowIndex);
                VGFieldImpl field = new VGFieldImpl(this, position, VGFieldState.EMPTY);
                column.add(field);
                emptyFields.put(position, field);
            }
            this.fields.add(column);
        }
    }

    public VGBoardImpl(VGBoardImpl source) {
        Objects.requireNonNull(source, "source");
        this.fieldsByState = new LinkedHashMap<VGFieldState, Map<VGPosition, VGFieldImpl>>();
        this.fieldsByState.put(VGFieldState.EMPTY, new LinkedHashMap());
        this.fieldsByState.put(VGFieldState.RED, new LinkedHashMap());
        this.fieldsByState.put(VGFieldState.YELLOW, new LinkedHashMap());
        int rows = source.getRows();
        int columns = source.getColumns();
        this.fields = new ArrayList<List<VGFieldImpl>>(columns);
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            List<VGFieldImpl> originColumn = source.fields.get(columnIndex);
            ArrayList<VGFieldImpl> column = new ArrayList<VGFieldImpl>(rows);
            for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                VGFieldImpl originField = originColumn.get(rowIndex);
                VGFieldImpl field = new VGFieldImpl(this, VGPosition.of(columnIndex, rowIndex), originField.getState());
                column.add(field);
                this.fieldsByState.get((Object)field.getState()).put(field.getPosition(), field);
            }
            this.fields.add(column);
        }
    }

    public String toString() {
        return String.format("VGBoard[size=%d, fields=%s]", this.fields.size(), this.fields);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VGBoardImpl) {
            VGBoardImpl other = (VGBoardImpl)obj;
            return this.fields.equals(other.fields);
        }
        return false;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    @Override
    public boolean hasFieldAt(VGPosition position) {
        int rowSize = this.getRows();
        int columnSize = this.getColumns();
        int row = position.getRow();
        int column = position.getColumn();
        return row >= 0 && row < rowSize && column >= 0 && column < columnSize;
    }

    @Override
    public VGField getFieldAt(VGPosition position) {
        if (!this.hasFieldAt(position)) {
            throw new IllegalArgumentException(String.format("Position %s out of range.", position));
        }
        return this.fields.get(position.getColumn()).get(position.getRow());
    }

    @Override
    public List<List<? extends VGField>> getFields() {
        ArrayList<List<? extends VGField>> result = new ArrayList<List<? extends VGField>>();
        this.fields.forEach(column -> result.add(new ArrayList(column)));
        return result;
    }

    public Map<VGPosition, VGField> getFieldsBeing(VGFieldState fieldState) {
        return Collections.unmodifiableMap(this.fieldsByState.get((Object)fieldState));
    }

    @Override
    public VGBoardImpl deepCopy() {
        return new VGBoardImpl(this);
    }

    void fieldChangedState(VGFieldImpl field, VGFieldState oldState) {
        this.fieldsByState.get((Object)oldState).remove(field.getPosition());
        this.fieldsByState.get((Object)field.getState()).put(field.getPosition(), field);
    }

    @Override
    public int getRows() {
        return this.fields.get(0).size();
    }

    @Override
    public int getColumns() {
        return this.fields.size();
    }

    @Override
    public VGField getNextFieldInColumn(VGAnswerEnum column) {
        if (column.equals((Object)VGAnswerEnum.FIRSTCOLUMN)) {
            return this.getNextField(0);
        }
        if (column.equals((Object)VGAnswerEnum.SECONDCOLUMN)) {
            return this.getNextField(1);
        }
        if (column.equals((Object)VGAnswerEnum.THIRDCOLUMN)) {
            return this.getNextField(2);
        }
        if (column.equals((Object)VGAnswerEnum.FOURTHCOLUMN)) {
            return this.getNextField(3);
        }
        if (column.equals((Object)VGAnswerEnum.FITFHCOLUMN)) {
            return this.getNextField(4);
        }
        if (column.equals((Object)VGAnswerEnum.SIXTHCOLUMN)) {
            return this.getNextField(5);
        }
        return this.getNextField(6);
    }

    private VGField getNextField(Integer indexInList) {
        for (VGFieldImpl field : this.fields.get(indexInList)) {
            if (!field.getState().equals((Object)VGFieldState.EMPTY)) continue;
            return field;
        }
        return null;
    }
}

