package de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayerBuilder;

/**
 * Implements {@link VGPlayerBuilder}.
 */
public class VGPlayerBuilderImpl implements VGPlayerBuilder {
    /**
     * The name of the player.
     */
    private Optional<String> name;

    /**
     * If {@code true}, the player will be using red tokens, else she will be using yellow tokens.
     */
    private boolean usingRedChips;

    /**
     * Creates an {@link VGPlayerBuilderImpl}.
     */
    VGPlayerBuilderImpl() {
        this.name = Optional.empty();
        this.usingRedChips = true;
    }

    @Override
    public VGPlayerBuilderImpl changeName(final String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public VGPlayer build() throws GameException {
        return new VGPlayerImpl(
                this.name.orElseThrow(),
                this.usingRedChips);
    }

    @Override
    public VGPlayerBuilder changeUsingRedChips(final boolean newUsingRedChips) {
        this.usingRedChips = newUsingRedChips;
        return this;
    }

    @Override
    public boolean isUsingRedChips() {
        return this.usingRedChips;
    }
}
