/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGBoard;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGField;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGFieldState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPosition;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl.VGBoardImpl;
import java.util.Objects;

final class VGFieldImpl
implements VGField {
    private final VGBoardImpl board;
    private final VGPosition position;
    private VGFieldState state;

    VGFieldImpl(VGBoardImpl board, VGPosition position, VGFieldState state) {
        this.board = Objects.requireNonNull(board, "board");
        this.position = Objects.requireNonNull(position, "position");
        this.state = state;
    }

    public String toString() {
        return String.format("VGField[position=%s, state=%s]", new Object[]{this.position, this.state});
    }

    public boolean equals(Object obj) {
        if (obj instanceof VGFieldImpl) {
            VGFieldImpl other = (VGFieldImpl)obj;
            return this.position.equals(other.position) && this.state.equals((Object)other.state);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.position, this.state});
    }

    @Override
    public VGBoard getBoard() {
        return this.board;
    }

    @Override
    public VGPosition getPosition() {
        return this.position;
    }

    @Override
    public VGFieldState getState() {
        return this.state;
    }

    @Override
    public void setState(VGFieldState newState) throws IllegalArgumentException {
        VGFieldState oldState = this.state;
        if (oldState.equals((Object)newState)) {
            return;
        }
        this.state = newState;
        this.board.fieldChangedState(this, oldState);
    }

    @Override
    public void placeToken(boolean redChip) throws GameException {
        VGFieldState newState = redChip ? VGFieldState.RED : VGFieldState.YELLOW;
        this.setState(newState);
    }
}

