package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.impl;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteGame;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteMoveChecker;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKantePlayer;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteState;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteStrategy;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.moves.KopfundZahlundKanteMove;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.moves.factory.KopfundZahlundKanteMoveFactory;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.moves.impl.DefaultKopfundZahlundKanteMoveFactory;

/**
 * Implements a KopfundZahl game.
 */
public final class KopfundZahlundKanteGameImpl extends DefaultGame<KopfundZahlundKantePlayer, 
                                                                   KopfundZahlundKanteState, 
                                                                   KopfundZahlundKanteMove,
                                                                   KopfundZahlundKanteStrategy> 
implements KopfundZahlundKanteGame {

    /**
     * The move Factory.
     */
    private final KopfundZahlundKanteMoveFactory moveFactory;

    /**
     * Creates a KopfundZahl game.
     *
     * @param id                        The ID of this game.
     * @param initialState              The initial state of the game.
     * @param strategies                The players' strategies.
     * @param maxComputationTimePerMove The maximum computation time per move in seconds.
     * @param moveChecker               The move checker.
     * @param observerFactoryProvider   The maximum computation time per move in seconds.
     * @throws IllegalArgumentException if the player sets do not match.
     * @throws InterruptedException     if creating the game has been interrupted.
     */
    KopfundZahlundKanteGameImpl(final int id, final KopfundZahlundKanteState initialState, final Map<String,
            KopfundZahlundKanteStrategy> strategies,
            final long maxComputationTimePerMove, final KopfundZahlundKanteMoveChecker moveChecker,
            final ObserverFactoryProvider observerFactoryProvider)
            throws IllegalArgumentException, InterruptedException {
        super(id, initialState, strategies, maxComputationTimePerMove, moveChecker, observerFactoryProvider);
        this.moveFactory = new DefaultKopfundZahlundKanteMoveFactory();
    }

    @Override
    public Optional<KopfundZahlundKanteMove> chooseRandomMove(final KopfundZahlundKantePlayer player, 
            final KopfundZahlundKanteState state) {
        return Optional.of(this.moveFactory.createTailMove());
    }

    @Override
    public String toString() {
        return String.format("KopfundZahlundKanteGame[id=%d, %s]", this.getId(), this.gameToString());
    }

}
