package de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

/**
 * Implements {@link GDStrategyFactoryProvider} by using the {@link ServiceLoader}.
 */
public final class GDDefaultStrategyFactoryProvider implements GDStrategyFactoryProvider {

    @Override
    public List<GDStrategyFactory> getStrategyFactories() {
        final ServiceLoader<GDStrategyFactory> services = ServiceLoader.load(GDStrategyFactory.class);
        final List<GDStrategyFactory> list = new ArrayList<>();
        services.iterator().forEachRemaining(list::add);
        return list;
    }

}
