/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.impl;

import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDGame;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDGameBuilder;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDPlayer;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDPlayerBuilder;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDStrategy;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.impl.GDGameImpl;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.impl.GDPlayerBuilderImpl;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.impl.GDStateImpl;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.moves.impl.AbstractGDMove;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;

public class GDGameBuilderImpl
implements GDGameBuilder {
    private ObserverFactoryProvider observerFactoryProvider = new DefaultObserverFactoryProvider();
    private Optional<GDPlayer> firstPlayer = Optional.empty();
    private Optional<GDStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<GDPlayer> secondPlayer = Optional.empty();
    private Optional<GDStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    GDGameBuilderImpl() {
    }

    @Override
    public GDPlayerBuilder createPlayerBuilder() {
        return new GDPlayerBuilderImpl();
    }

    @Override
    public GDGameBuilder addPlayer(GDPlayer player, GDStrategy strategy) throws GameException {
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public GDGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public GDGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public GDGame build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("A Gefangenen Dilemma game needs two players.");
        }
        GDStateImpl initialState = new GDStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, GDStrategy> strategies = new LinkedHashMap<String, GDStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new GDGameImpl(id, initialState, strategies, this.maxComputationTimePerMove, AbstractGDMove.class::isInstance, this.observerFactoryProvider);
    }

    public ObserverFactoryProvider getObserverFactoryProvider() {
        return this.observerFactoryProvider;
    }

    public int getMaxComputationTimePerMove() {
        return this.maxComputationTimePerMove;
    }
}

