/*
 * Decompiled with CFR 0.152.
 */
package de.schereSteinPapier.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.PlayerState;
import de.schereSteinPapier.domain.SSPPlayer;
import de.schereSteinPapier.domain.SSPState;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class SSPStateImpl
implements SSPState {
    private final SSPPlayer firstPlayer;
    private final SSPPlayer secondPlayer;

    SSPStateImpl(SSPPlayer firstPlayer, SSPPlayer secondPlayer) throws GameException {
        this.firstPlayer = Objects.requireNonNull(firstPlayer, "firstPlayer");
        this.secondPlayer = Objects.requireNonNull(secondPlayer, "secondPlayer");
        if (this.firstPlayer.getName().equals(this.secondPlayer.getName())) {
            throw new IllegalArgumentException(String.format("Both players have the same name '%s'.", this.firstPlayer.getName()));
        }
    }

    SSPStateImpl(SSPStateImpl source) {
        this.firstPlayer = (SSPPlayer)source.firstPlayer.deepCopy();
        this.secondPlayer = (SSPPlayer)source.secondPlayer.deepCopy();
    }

    @Override
    public SSPPlayer getFirstPlayer() {
        return this.firstPlayer;
    }

    @Override
    public SSPPlayer getSecondPlayer() {
        return this.secondPlayer;
    }

    public String toString() {
        return String.format("SSPState[firstPlayer=%s, secondPlayer=%s]", this.firstPlayer, this.secondPlayer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SSPStateImpl) {
            SSPStateImpl other = (SSPStateImpl)obj;
            return this.firstPlayer.equals(other.firstPlayer) && this.secondPlayer.equals(other.secondPlayer);
        }
        return false;
    }

    public SSPState deepCopy() {
        return new SSPStateImpl(this);
    }

    public int hashCode() {
        return Objects.hash(this.firstPlayer, this.secondPlayer);
    }

    public Map<String, SSPPlayer> getPlayers() {
        LinkedHashMap<String, SSPPlayer> result = new LinkedHashMap<String, SSPPlayer>();
        result.put(this.firstPlayer.getName(), this.firstPlayer);
        result.put(this.secondPlayer.getName(), this.secondPlayer);
        return result;
    }

    public Set<SSPPlayer> computeNextPlayers() {
        LinkedHashSet<SSPPlayer> playersWithoutMove = new LinkedHashSet<SSPPlayer>();
        if (this.firstPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.firstPlayer);
        }
        if (this.secondPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.secondPlayer);
        }
        return playersWithoutMove;
    }

    public void nextTurn() {
        Set<SSPPlayer> playersWithoutMove = this.computeNextPlayers();
        if (playersWithoutMove.isEmpty()) {
            String answerOfFirstPlayer = this.firstPlayer.getAnswer().orElseThrow();
            String answerOfSecondPlayer = this.secondPlayer.getAnswer().orElseThrow();
            Double outcomeOfFirstPlayer = this.firstPlayer.getPossibleOutcomes().get(answerOfFirstPlayer).get(answerOfSecondPlayer);
            this.firstPlayer.setState(SSPStateImpl.outcomeToState(outcomeOfFirstPlayer));
            this.firstPlayer.setOutcome(outcomeOfFirstPlayer);
            Double outcomeOfSecondPlayer = this.secondPlayer.getPossibleOutcomes().get(answerOfFirstPlayer).get(answerOfSecondPlayer);
            this.secondPlayer.setState(SSPStateImpl.outcomeToState(outcomeOfSecondPlayer));
            this.secondPlayer.setOutcome(outcomeOfSecondPlayer);
        }
    }

    private static PlayerState outcomeToState(Double outcome) {
        return outcome > 0.0 ? PlayerState.WON : (outcome < 0.0 ? PlayerState.LOST : PlayerState.DRAW);
    }
}

