package de.fhdw.gaming.ipspiel22.vierGewinnt.moves.factory;

import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPosition;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.VGMove;

/**
 * Allows to create Vier gewinnt moves.
 */
public interface VGMoveFactory {
    /**
     * Creates a move "First Column".
     */
    VGMove createFirstColumnMove(); 

    /**
     * Creates a move "Second Column".
     */
    VGMove createSecondColumnMove();

    /**
     * Creates a move "Third Column".
     */
    VGMove createThirdColumnMove();

    /**
     * Creates a move "Fourth Column".
     */
    VGMove createFourthColumnMove();

    /**
     * Creates a move "Fifth Column".
     */
    VGMove createFifthColumnMove();

    /**
     * Creates a move "Sixth Column".
     */
    VGMove createSixthColumnMove();

    /**
     * Creates a move "Seventh Column".
     */
    VGMove createSeventhColumnMove();
    
    /**
     * Creates a move that places a token on the board.
     * 
     * @param redPlayer  {@code true} if a red token is placed, and {@code false} if a yellow token is placed.
     * @param position   The position of the token placed on the board.
     */
    VGMove createTokenMove(boolean redPlayer, VGPosition position);
      
}
