package de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl;

import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPosition;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.VGMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.factory.VGMoveFactory;

/**
 * Implements {@link VGMoveFactory}.
 */
public class VGDefaultMoveFactory implements VGMoveFactory {

    @Override
    public VGMove createFirstColumnMove() {
        return new VG1ColumnMove();
    }

    @Override
    public VGMove createSecondColumnMove() {
        return new VG2ColumnMove();
    }

    @Override
    public VGMove createThirdColumnMove() {
        return new VG3ColumnMove();
    }

    @Override
    public VGMove createFourthColumnMove() {
        return new VG4ColumnMove();
    }

    @Override
    public VGMove createFifthColumnMove() {
        return new VG5ColumnMove();
    }

    @Override
    public VGMove createSixthColumnMove() {
        return new VG6ColumnMove();
    }

    @Override
    public VGMove createSeventhColumnMove() {
        return new VG7ColumnMove();
    }

    @Override
    public VGMove createTokenMove(final boolean redPlayer, final VGPosition position) {
        return new VGPlaceTokenMove(redPlayer, position);
    }

}
