package de.schereSteinPapier.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * A Demo {@link GameBuilderFactory} which allows to create a SSP game builder.
 */
public interface SSPGameBuilderFactory extends GameBuilderFactory {
    /**
     * Player's outcome on Schere/Schere.
     */
    String PARAM_PLAYER_OUTCOME_ON_SCHERE_SCHERE = "playerOutcomeOnSchereSchere"; //playerOutcomeOnSchereSchere

    /**
     * Player's outcome on Schere/Stein.
     */
    String PARAM_PLAYER_OUTCOME_ON_SCHERE_STEIN = "playerOutcomeOnSchereStein";

    /**
     * Player's outcome on Schere/Papier.
     */
    String PARAM_PLAYER_OUTCOME_ON_SCHERE_PAPIER = "playerOutcomeOnScherePapier";

    /**
     * Player's outcome on Stein/Schere.
     */
    String PARAM_PLAYER_OUTCOME_ON_STEIN_SCHERE = "playerOutcomeOnSteinSchere";

    /**
     * Player's outcome on Stein/Stein.
     */
    String PARAM_PLAYER_OUTCOME_ON_STEIN_STEIN = "playerOutcomeOnSteinStein"; //playerOutcomeOnSteinStein

    /**
     * Player's outcome on Stein/Papier.
     */
    String PARAM_PLAYER_OUTCOME_ON_STEIN_PAPIER = "playerOutcomeOnSteinPapier"; //playerOutcomeOnSteinPapier

    /**
     * Player's outcome on Papier/Schere.
     */
    String PARAM_PLAYER_OUTCOME_ON_PAPIER_SCHERE = "playerOutcomeOnPapierSchere"; //playerOutcomeOnPapierSchere

    /**
     * Player's outcome on Papier/Stein.
     */
    String PARAM_PLAYER_OUTCOME_ON_PAPIER_STEIN = "playerOutcomeOnPapierStein";

    /**
     * Player's outcome on Papier/Papier.
     */
    String PARAM_PLAYER_OUTCOME_ON_PAPIER_PAPIER = "playerOutcomeOnPapierPapier";

    @Override
    SSPGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
}
