package de.schereSteinPapier.strategy;

import java.util.Optional;

import de.schereSteinPapier.domain.SSPPlayer;
import de.schereSteinPapier.domain.SSPState;
import de.schereSteinPapier.domain.SSPStrategy;
import de.schereSteinPapier.moves.SSPMove;
import de.schereSteinPapier.moves.factory.SSPMoveFactory;

/**
 * Implements {@link SSPStrategy} by always saying "Papier".
 */
public class SSPSayPapierStrategy implements SSPStrategy {

    /**
     * The factory for creating SSP moves.
     */
    private final SSPMoveFactory moveFactory;

    /**
     * Creates an {@link SSPSayPapierStrategy}.
     *
     * @param moveFactory The factory for creating SSP moves.
     */
    public SSPSayPapierStrategy(final SSPMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<SSPMove> computeNextMove(final int gameId, final SSPPlayer player, final SSPState state) {
        return Optional.of(this.moveFactory.createPapierMove());
    }

    @Override
    public String toString() {
        return SSPSayPapierStrategy.class.getSimpleName();
    }
}
