/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl.validation;

import de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum C4BoardValidatorInfo {
    ROW_COUNT{

        @Override
        public String toInfoString(int playerCount) {
            return String.format("The row count must be greater than or equal to %d.\nThe row count must not exceed %d.\nRow count * column count must not exceed %d.\nRow count * column count must be less than %d * solution size.", 2, 0x3FFFFFFF, Integer.MAX_VALUE, playerCount);
        }
    }
    ,
    COLUMN_COUNT{

        @Override
        public String toInfoString(int playerCount) {
            return String.format("The column count must be greater than or equal to %d.\nThe column count must not exceed %d.\nRow count * column count must not exceed %d.\nRow count * column count must be less than %d * solution size.", 2, 0x3FFFFFFF, Integer.MAX_VALUE, playerCount);
        }
    }
    ,
    SOLUTION_SIZE{

        @Override
        public String toInfoString(int playerCount) {
            return String.format("The solution size must be greater than or equal to %d.\nThe solution size must not exceed %d.\nThe solution size must not exceed the numbers of rows and columns on the board.\n%d * solution size must be greater than row count * column count.", 2, C4BoardLimits.MAX_SOLUTION_SIZE, playerCount);
        }
    };


    public abstract String toInfoString(int var1);
}

