/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.ssp.strategy;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspPlayer;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspState;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspStrategy;
import de.fhdw.gaming.ipspiel23.ssp.moves.SspMove;
import de.fhdw.gaming.ipspiel23.ssp.moves.factory.SspMoveFactory;
import java.util.Optional;
import java.util.Random;

public final class SspMixedStrategy
implements SspStrategy {
    private static final Random RND = new Random();
    private final SspMoveFactory moveFactory;

    SspMixedStrategy(SspMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<SspMove> computeNextMove(int gameId, SspPlayer player, SspState state) throws GameException, InterruptedException {
        switch (RND.nextInt(3)) {
            case 0: {
                return Optional.of(this.moveFactory.createPaperMove());
            }
            case 1: {
                return Optional.of(this.moveFactory.createScissorsMove());
            }
            case 2: {
                return Optional.of(this.moveFactory.createStoneMove());
            }
        }
        throw new GameException("mixedStrategy: random number outside of expectation!");
    }

    public String toString() {
        return SspMixedStrategy.class.getSimpleName();
    }

    public boolean equals(Object obj) {
        return obj != null && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return super.hashCode() * this.toString().hashCode();
    }
}

