/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl.validation;

import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardValidationStateUpdateContext;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardValidatorInfo;
import java.util.function.Consumer;

public final class C4BoardValidator
implements Validator<Integer> {
    private final C4BoardLimits state;
    private final Consumer<C4BoardValidationStateUpdateContext> updateAction;
    private final C4BoardValidationStateUpdateContext updateContext;
    private final C4BoardValidatorInfo info;

    public C4BoardValidator(C4BoardLimits state, Consumer<C4BoardValidationStateUpdateContext> updateAction, C4BoardValidatorInfo info) {
        this.updateAction = updateAction;
        this.state = state;
        this.updateContext = new C4BoardValidationStateUpdateContext(state, 0);
        this.info = info;
    }

    public Integer validate(Integer value) throws InputProviderException {
        this.updateContext.setValue(value);
        this.updateAction.accept(this.updateContext);
        this.state.assertIsValid();
        return value;
    }

    public String getInfo() {
        return this.info.toInfoString(this.state.getPlayerCount());
    }
}

