/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel23-c4.
 *
 * Ipspiel23-c4 is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel23-c4 is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel23-c4. If not, see
 * <http://www.gnu.org/licenses/>.
 */
// literally open everything, because unit tests need to access all of this
// honestly how can you make a language THIS verbose? :C
// life is so much easier in C#...
// don't want to expose something? just declare it as internal AND THAT'S IT
// Still wan't another assembly to access internals? just make it a friend assembly.
open module de.fhdw.gaming.ipspiel23.connectFour {

    // these will be exposed to external usage
    exports de.fhdw.gaming.ipspiel23.c4.domain;
    exports de.fhdw.gaming.ipspiel23.c4.moves;
    exports de.fhdw.gaming.ipspiel23.c4.moves.factory;
    exports de.fhdw.gaming.ipspiel23.c4.strategies;
    
    // our own dependencies
    requires transitive de.fhdw.gaming.core;
    requires jdk.unsupported;
    
    // not sure to be honest (but without this everything breaks)
    uses de.fhdw.gaming.ipspiel23.c4.strategies.IC4StrategyFactory;
    uses de.fhdw.gaming.ipspiel23.c4.domain.IC4GameBuilderFactory;

    // DI setup
    provides de.fhdw.gaming.core.domain.GameBuilderFactory
        with de.fhdw.gaming.ipspiel23.c4.domain.impl.C4GameBuilderFactory;
    provides de.fhdw.gaming.ipspiel23.c4.domain.IC4GameBuilderFactory
        with de.fhdw.gaming.ipspiel23.c4.domain.impl.C4GameBuilderFactory;
    provides de.fhdw.gaming.ipspiel23.c4.strategies.IC4StrategyFactory
        with de.fhdw.gaming.ipspiel23.c4.strategies.internals.C4RandomMoveStrategyFactory;
}
