/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl.validation;

import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardDimensions;

public class C4BoardLimits {
    public static final int MIN_ROW_COUNT = 2;
    public static final int MIN_COLUMN_COUNT = 2;
    public static final int MAX_ROW_COUNT = 0x3FFFFFFF;
    public static final int MAX_COLUMN_COUNT = 0x3FFFFFFF;
    public static final int MAX_FIELD_COUNT = Integer.MAX_VALUE;
    public static final int MIN_SOLUTION_SIZE = 2;
    public static final int MAX_SOLUTION_SIZE = Math.max(0x3FFFFFFF, 0x3FFFFFFF);
    public static final int MIN_NUMBER_OF_PLAYERS = 1;
    public static final int MAX_NUMBER_OF_PLAYERS = 0x3FFFFFFF;
    private final C4BoardDimensions boardDimensions;
    private int solutionSize;
    private final int playerCount;

    public C4BoardLimits(int playerCount, int initialRowCount, int initialColumnCount, int initialSolutionSize) {
        this.playerCount = playerCount;
        this.boardDimensions = new C4BoardDimensions(initialRowCount, initialColumnCount);
        this.solutionSize = initialSolutionSize;
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    public int getRowCount() {
        return this.boardDimensions.getRowCount();
    }

    public void setRowCount(int rowCount) {
        this.boardDimensions.setRowCount(rowCount);
    }

    public int getColumnCount() {
        return this.boardDimensions.getColumnCount();
    }

    public void setColumnCount(int columnCount) {
        this.boardDimensions.setColumnCount(columnCount);
    }

    public int getSolutionSize() {
        return this.solutionSize;
    }

    public void setSolutionSize(int solutionSize) {
        this.solutionSize = solutionSize;
    }

    public void assertIsValid() throws InputProviderException {
        this.assertStaticLimits();
        this.boardDimensions.assertStaticLimits();
        int fieldCount = this.boardDimensions.getRowCount() * this.boardDimensions.getColumnCount();
        if (fieldCount < 0) {
            throw new InputProviderException("The board is too large: the total number of fields exceeds the maximum allowed value (2147483647).");
        }
        if (this.solutionSize > Math.max(this.boardDimensions.getRowCount(), this.boardDimensions.getColumnCount())) {
            throw new InputProviderException("The required solution size is too large: the solution size exceeds the number of rows and columns on the board. This is dumb.");
        }
        if (fieldCount < this.playerCount * this.solutionSize) {
            throw new InputProviderException("The current board settings do not allow every player to win: the number of fields is too small to allow every player to form a solution, if players take turns placing tokens.");
        }
    }

    private void assertStaticLimits() throws InputProviderException {
        if (this.solutionSize < 2) {
            throw new InputProviderException("The specified solution size is too small: the solution size must be at least 2.");
        }
        if (this.solutionSize > MAX_SOLUTION_SIZE) {
            throw new InputProviderException("The specified solution size is too large: the solution size must not exceed " + MAX_SOLUTION_SIZE + ".");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof C4BoardLimits)) {
            return false;
        }
        C4BoardLimits other = (C4BoardLimits)object;
        return this.boardDimensions.equals(other.boardDimensions) && this.solutionSize == other.solutionSize && this.playerCount == other.playerCount;
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + this.boardDimensions.hashCode();
        hash = hash * 31 + this.solutionSize;
        hash = hash * 31 + this.playerCount;
        return hash;
    }
}

