/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4GameBuilder;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4GameBuilderFactory;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4PlayerBuilder;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4GameBuilder;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardValidator;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardValidatorInfo;
import de.fhdw.gaming.ipspiel23.c4.moves.impl.C4DefaultMoveFactory;
import de.fhdw.gaming.ipspiel23.c4.strategies.C4DefaultStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel23.c4.strategies.IC4Strategy;
import de.fhdw.gaming.ipspiel23.c4.strategies.IC4StrategyFactory;
import de.fhdw.gaming.ipspiel23.c4.strategies.IC4StrategyFactoryProvider;
import de.fhdw.gaming.ipspiel23.c4.utils.ByRef;
import de.fhdw.gaming.ipspiel23.c4.utils.MakeRef;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public final class C4GameBuilderFactory
implements IC4GameBuilderFactory {
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<IC4Strategy> strategies;

    public C4GameBuilderFactory() {
        this(new C4DefaultStrategyFactoryProvider());
    }

    public C4GameBuilderFactory(IC4StrategyFactoryProvider strategyFactoryProvider) {
        C4DefaultMoveFactory moveFactory = new C4DefaultMoveFactory();
        List<IC4StrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new HashSet<IC4Strategy>();
        for (IC4StrategyFactory factory : factories) {
            IC4Strategy strategy = factory.create(moveFactory);
            this.strategies.add(strategy);
        }
    }

    public String getName() {
        return "Connect 2 <= N <= 1,073,741,823";
    }

    public int getMinimumNumberOfPlayers() {
        return 1;
    }

    public int getMaximumNumberOfPlayers() {
        return 0x3FFFFFFF;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<IC4Strategy>(this.strategies);
    }

    @Override
    public IC4GameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            C4GameBuilder gameBuilder = new C4GameBuilder();
            Map dataSet = inputProvider.needInteger("playerCount", "Number of players", Optional.of(2), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(0x3FFFFFFF))}).needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            int maxComputationTime = (Integer)dataSet.get("maxComputationTimePerMove");
            gameBuilder.changeMaximumComputationTimePerMove(maxComputationTime);
            int playerCount = (Integer)dataSet.get("playerCount");
            ByRef<InputProvider> inputProviderRef = MakeRef.of(inputProvider);
            ByRef<Map<String, Object>> dataSetRef = MakeRef.of(dataSet);
            for (int i = 0; i < playerCount; ++i) {
                this.addPlayer(inputProviderRef, dataSetRef, gameBuilder);
            }
            C4BoardLimits sharedValidationState = new C4BoardLimits(playerCount, 6, 7, 4);
            C4BoardValidator rowCountValidator = new C4BoardValidator(sharedValidationState, context -> context.getState().setRowCount(context.getValue()), C4BoardValidatorInfo.ROW_COUNT);
            C4BoardValidator columnCountValidator = new C4BoardValidator(sharedValidationState, context -> context.getState().setColumnCount(context.getValue()), C4BoardValidatorInfo.COLUMN_COUNT);
            C4BoardValidator solutionSizeValidator = new C4BoardValidator(sharedValidationState, context -> context.getState().setSolutionSize(context.getValue()), C4BoardValidatorInfo.SOLUTION_SIZE);
            InputProvider boardInputProvider = inputProviderRef.getValue().getNext(dataSetRef.getValue());
            Map boardDataSet = boardInputProvider.needInteger("boardRows", "Number of rows", Optional.of(6), new Validator[]{rowCountValidator}).needInteger("boardColumns", "Number of columns", Optional.of(7), new Validator[]{columnCountValidator}).needInteger("requiredSolutionSize", "Number of consecutive pieces required to win", Optional.of(4), new Validator[]{solutionSizeValidator}).requestData("Board properties");
            sharedValidationState.assertIsValid();
            gameBuilder.changeBoardRows((Integer)boardDataSet.get("boardRows")).changeBoardColumns((Integer)boardDataSet.get("boardColumns")).changeRequiredSolutionSize((Integer)boardDataSet.get("requiredSolutionSize"));
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating the Connect N game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private void addPlayer(ByRef<InputProvider> inputProvider, ByRef<Map<String, Object>> lastDataSet, IC4GameBuilder gameBuilder) throws InputProviderException, GameException {
        IC4PlayerBuilder playerBuilder = gameBuilder.createPlayerBuilder();
        int playerToken = playerBuilder.getToken();
        String title = String.format("Player %d", playerToken);
        InputProvider playerInputProvider = inputProvider.getValue().getNext(lastDataSet.getValue());
        Map dataSet = playerInputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies).requestData(title);
        String name = (String)dataSet.get("playerName");
        IC4Strategy strategy = (IC4Strategy)dataSet.get("playerStrategy");
        IC4Player player = playerBuilder.changeName(name).build();
        gameBuilder.addPlayer(player, strategy);
        inputProvider.setValue(playerInputProvider);
        lastDataSet.setValue(dataSet);
    }
}

