package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.probability;

import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.IDilemmaStrategyFactory;

/**
 * Implements {@link IDilemmaStrategyFactory} by creating a {@link DilemmaCooperateStrategy}.
 */
public class DilemmaProbabilityStrategyFactory implements IDilemmaStrategyFactory {

    /**
     * Creates strategy which is visible for the player to chose.
     */
    @Override
    public IDilemmaStrategy create(final IDilemmaMoveFactory moveFactory) {
        return new DilemmaProbabilityStrategy(moveFactory);
    }
}
