package de.fhdw.gaming.ipspiel23.ssp.strategy;

import de.fhdw.gaming.ipspiel23.ssp.domain.SspStrategy;
import de.fhdw.gaming.ipspiel23.ssp.domain.factory.SspStrategyFactory;
import de.fhdw.gaming.ipspiel23.ssp.moves.factory.SspMoveFactory;

/**
 * Implements {@link SspStrategyFactory} by creating a {@link SspMixedStrategy}.
 */
public class SspMixedStrategyFactory  implements SspStrategyFactory {
    
    @Override
    public SspStrategy create(final SspMoveFactory moveFactory) {
        return new SspMixedStrategy(moveFactory);
    }
}
