package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.reactive;

import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.IDilemmaStrategyFactory;

/**
 * Implements {@link IDilemmaStrategyFactory} by creating a {@link DilemmaReactiveStrategy}.
 */
public class DilemmaReactiveStrategyFactory implements IDilemmaStrategyFactory {

    /**
     * Creates strategy which is visible for the player to chose.
     */
    @Override
    public IDilemmaStrategy create(final IDilemmaMoveFactory moveFactory) {
        return new DilemmaReactiveStrategy(moveFactory);
    }
}
