package de.fhdw.gaming.ipspiel23.c4.gui.event;

import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;

/**
 * Represents an {@link C4BoardEvent} where the user selected a field to make a move.
 */
public class C4MakeMoveBoardEvent implements C4BoardEvent {

    /**
     * The position of the field selected.
     */
    private final IC4Position fieldPosition;

    /**
     * Constructor.
     *
     * @param fieldPosition The position of the field selected.
     */
    public C4MakeMoveBoardEvent(final IC4Position fieldPosition) {
        this.fieldPosition = fieldPosition;
    }

    /**
     * Returns the position of the field selected.
     */
    public IC4Position getFieldPosition() {
        return this.fieldPosition;
    }


    @Override
    public void accept(final C4BoardEventVisitor visitor) {
        visitor.handleMakeMove(this);
    }
}
