/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.gui.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4State;
import de.fhdw.gaming.ipspiel23.c4.gui.C4BoardEventProvider;
import de.fhdw.gaming.ipspiel23.c4.gui.event.C4BoardEventVisitor;
import de.fhdw.gaming.ipspiel23.c4.gui.event.C4MakeMoveBoardEvent;
import de.fhdw.gaming.ipspiel23.c4.gui.impl.C4GuiObserverImpl;
import de.fhdw.gaming.ipspiel23.c4.moves.IC4Move;
import de.fhdw.gaming.ipspiel23.c4.moves.factory.IC4MoveFactory;
import de.fhdw.gaming.ipspiel23.c4.strategies.IC4Strategy;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class C4InteractiveStrategy
implements IC4Strategy {
    private final IC4MoveFactory moveFactory;

    C4InteractiveStrategy(IC4MoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<IC4Move> computeNextMove(int gameId, final IC4Player player, IC4State state) throws GameException {
        Optional<C4BoardEventProvider> provider = C4GuiObserverImpl.getEventProvider(gameId);
        if (provider.isEmpty()) {
            return Optional.empty();
        }
        final AtomicReference move = new AtomicReference();
        provider.get().waitForEvent(player, state).accept(new C4BoardEventVisitor(){

            @Override
            public void handleMakeMove(C4MakeMoveBoardEvent event) {
                move.setPlain(C4InteractiveStrategy.this.moveFactory.createMove(player, event.getFieldPosition()));
            }
        });
        return Optional.ofNullable((IC4Move)move.getPlain());
    }

    public String toString() {
        return C4InteractiveStrategy.class.getSimpleName();
    }

    public boolean isInteractive() {
        return true;
    }

    public void abortRequested(int gameId) {
        Optional<C4BoardEventProvider> provider = C4GuiObserverImpl.getEventProvider(gameId);
        provider.ifPresent(C4BoardEventProvider::cancelWaiting);
    }
}

