package de.fhdw.gaming.ipspiel23.c4.collections;

import java.util.Collection;

/**
 * Represents a generic read-only collection of key/value pairs.
 * 
 * @param <TKey> The type of keys in the read-only dictionary.
 * @param <TValue> The type of values in the read-only dictionary.
 */
public interface IReadOnlyDictionary<TKey, TValue> {

    /**
     * Determines whether the read-only dictionary contains an element that has the specified key.
     * 
     * @param key The key to locate.
     * @return {@code true} if the read-only dictionary contains an element that has the specified key; 
     * otherwise, {@code false}.
     */
    boolean containsKey(TKey key);

    /**
     * Tries to get the value associated with the specified key in the dictionary.
     * 
     * @param key The key of the value to get.
     * @return A {@code TValue} instance. When the method is successful, the returned object is the value associated 
     * with the specified {@code key}. When the method fails, it returns the default value for {@code TValue}.
     */
    TValue getValueOrDefault(TKey key);

    /**
     * Gets the number of key/value pairs contained in the read-only dictionary.
     * 
     * @return The number of key/value pairs contained in the read-only dictionary.
     */
    int count();

    /**
     * Gets a collection containing the keys in the read-only dictionary.
     * 
     * @return A collection containing the keys in the read-only dictionary.
     */
    Collection<TKey> getKeys();

    /**
     * Gets a collection containing the values in the read-only dictionary.
     * 
     * @return A collection containing the values in the read-only dictionary.
     */
    Collection<TValue> getValues();
}
