/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgGameBuilder;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgGameBuilderFactory;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgPlayer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgPlayerBuilder;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgStrategy;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.factory.FzgStrategyDefaultFactoryProvider;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.factory.FzgStrategyFactory;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.factory.FzgStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.impl.FzgGameBuilderImpl;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.AnswerOptions;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.impl.AnswerFactoryImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class FzgGameBuilderFactoryImpl
implements FzgGameBuilderFactory {
    private static final String GAME_NAME = "Freizeitgestaltung";
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<FzgStrategy> strategies;

    public FzgGameBuilderFactoryImpl() {
        this(new FzgStrategyDefaultFactoryProvider());
    }

    FzgGameBuilderFactoryImpl(FzgStrategyFactoryProvider strategyFactoryProvider) {
        AnswerFactoryImpl answerFactory = new AnswerFactoryImpl();
        List<FzgStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<FzgStrategy>();
        for (FzgStrategyFactory factory : factories) {
            this.strategies.add(factory.create(answerFactory));
        }
    }

    public String getName() {
        return GAME_NAME;
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<FzgStrategy>(this.strategies);
    }

    @Override
    public FzgGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            FzgGameBuilderImpl gameBuilder = new FzgGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayerData(firstPlayerInputProvider, "Player 1 / Gabi", true);
            FzgPlayer firstPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), firstPlayerData);
            FzgStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayer(firstPlayer, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayerData(secondPlayerInputProvider, "Player 2 / Klaus", false);
            FzgPlayer secondPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), secondPlayerData);
            FzgStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayer(secondPlayer, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating Demo game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayerData(InputProvider inputProvider, String title, Boolean isGabi) throws GameException, InputProviderException {
        inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("PlayerOutcomeOnCinCin", "Player's outcome on Cinema/Cinema", isGabi != false ? Optional.of(2) : Optional.of(1), new Validator[0]).needInteger("PlayerOutcomeOnCinFoot", "Player's outcome on Cinema/Football", Optional.of(0), new Validator[0]).needInteger("PlayerOutcomeOnFootCin", "Player's outcome on Football/Cinema", Optional.of(0), new Validator[0]).needInteger("PlayerOutcomeOnFootFoot", "Player's outcome on Football/Football", isGabi != false ? Optional.of(1) : Optional.of(2), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        return inputProvider.requestData(title);
    }

    private FzgPlayer createPlayer(FzgPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<AnswerOptions, Map<AnswerOptions, Double>> possibleOutcomes = new LinkedHashMap<AnswerOptions, Map<AnswerOptions, Double>>();
        LinkedHashMap<AnswerOptions, Double> possibleOutcomesCinema = new LinkedHashMap<AnswerOptions, Double>();
        possibleOutcomesCinema.put(AnswerOptions.CINEMA, Double.valueOf(((Integer)playerData.get("PlayerOutcomeOnCinCin")).intValue()));
        possibleOutcomesCinema.put(AnswerOptions.FOOTBALL, Double.valueOf(((Integer)playerData.get("PlayerOutcomeOnCinFoot")).intValue()));
        possibleOutcomes.put(AnswerOptions.CINEMA, possibleOutcomesCinema);
        LinkedHashMap<AnswerOptions, Double> possibleOutcomesFootball = new LinkedHashMap<AnswerOptions, Double>();
        possibleOutcomesFootball.put(AnswerOptions.CINEMA, Double.valueOf(((Integer)playerData.get("PlayerOutcomeOnFootCin")).intValue()));
        possibleOutcomesFootball.put(AnswerOptions.FOOTBALL, Double.valueOf(((Integer)playerData.get("PlayerOutcomeOnFootFoot")).intValue()));
        possibleOutcomes.put(AnswerOptions.FOOTBALL, possibleOutcomesFootball);
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes).build();
    }

    private FzgStrategy getStrategy(Map<String, Object> playerData) {
        return (FzgStrategy)playerData.get("playerStrategy");
    }
}

