/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation;

import de.fhdw.gaming.ipspiel23.c4.domain.C4Direction;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4SolutionSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4BoardSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4SolutionSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation.C4SolutionAnalyzerDiagonal;
import java.util.Set;

public class C4SolutionAnalyzerDiagonalLeft
extends C4SolutionAnalyzerDiagonal {
    public C4SolutionAnalyzerDiagonalLeft(C4BoardSlim board) {
        super(board, C4Direction.NORTH_EAST);
    }

    @Override
    public IC4SolutionSlim tryFindFirstSolution(IC4SolutionSlim currentSolution, boolean updateCache) {
        IC4SolutionSlim solution = currentSolution;
        int iteration = 0;
        int startRow = this.targetCount();
        while (solution == null && startRow < this.rowMax()) {
            if (this.mayContainSolution(iteration)) {
                solution = this.tryFindFirstSolution(startRow, 0, iteration, updateCache);
            }
            ++startRow;
            ++iteration;
        }
        int startCol = 1;
        while (solution == null && startCol < this.colMax() - this.targetCount()) {
            if (this.mayContainSolution(iteration)) {
                solution = this.tryFindFirstSolution(this.rowMax() - 1, startCol, iteration, updateCache);
            }
            ++startCol;
            ++iteration;
        }
        return solution;
    }

    private IC4SolutionSlim tryFindFirstSolution(int startRow, int startCol, int iteration, boolean updateCache) {
        int count = 0;
        int lastToken = 0;
        int row = startRow;
        boolean isDiagonalFull = true;
        for (int col = startCol; row >= 0 && col < this.colMax(); --row, ++col) {
            int token = this.board().getTokenUnsafe(row, col);
            if ((count = C4SolutionAnalyzerDiagonalLeft.countConsecutivesBranchless(count, token, lastToken)) >= this.targetCount()) {
                return this.scanRemaining(token, row, col);
            }
            isDiagonalFull &= token != 0;
            lastToken = token;
        }
        if (updateCache && isDiagonalFull) {
            this.noSolutionIn(iteration);
        }
        return null;
    }

    @Override
    public void findAllSolutions(Set<IC4SolutionSlim> resultSet, boolean updateCache) {
        int iteration = 0;
        int startRow = this.targetCount();
        while (startRow < this.rowMax()) {
            if (this.mayContainSolution(iteration)) {
                this.findAllSolutions(resultSet, startRow, 0, iteration, updateCache);
            }
            ++startRow;
            ++iteration;
        }
        int startCol = 1;
        while (startCol < this.colMax() - this.targetCount()) {
            if (this.mayContainSolution(iteration)) {
                this.findAllSolutions(resultSet, this.rowMax() - 1, startCol, iteration, updateCache);
            }
            ++startCol;
            ++iteration;
        }
    }

    private void findAllSolutions(Set<IC4SolutionSlim> resultSet, int startRow, int startCol, int iteration, boolean updateCache) {
        int count = 0;
        int lastToken = 0;
        int row = startRow;
        boolean isDiagonalFull = true;
        boolean diagonalContainsSolution = false;
        for (int col = startCol; row >= 0 && col < this.colMax(); --row, ++col) {
            int token = this.board().getTokenUnsafe(row, col);
            if ((count = C4SolutionAnalyzerDiagonalLeft.countConsecutivesBranchless(count, token, lastToken)) >= this.targetCount()) {
                count = 0;
                C4SolutionSlim solution = this.scanRemaining(token, row, col);
                resultSet.add(solution);
                diagonalContainsSolution = true;
                row = solution.getRowIndexEnd();
                col = solution.getColumnIndexEnd();
            }
            isDiagonalFull &= token != 0;
            lastToken = token;
        }
        if (updateCache && isDiagonalFull && !diagonalContainsSolution) {
            this.noSolutionIn(iteration);
        }
    }

    @Override
    protected C4SolutionSlim scanRemaining(int token, int startRow, int startCol) {
        int col;
        int row = startRow - 1;
        for (col = startCol + 1; row >= 0 && col < this.colMax() && this.board().getTokenUnsafe(row, col) == token; --row, ++col) {
        }
        return this.solutionOf(token, ++row, --col, this.board().getMinimumSolutionSize() + col - startCol);
    }
}

