package de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * Creates a {@link FzgGameBuilder}.
 *
 */
public interface FzgGameBuilderFactory extends GameBuilderFactory {

    /**
     * Player's outcome on Cinema / Cinema.
     */
    String PARAM_PLAYER_OUTCOME_ON_CIN_CIN = "PlayerOutcomeOnCinCin";

    /**
     * Player's outcome on Cinema / Football.
     */
    String PARAM_PLAYER_OUTCOME_ON_CIN_FOOT = "PlayerOutcomeOnCinFoot";

    /**
     * Player's outcome on Football / Football.
     */
    String PARAM_PLAYER_OUTCOME_ON_FOOT_FOOT = "PlayerOutcomeOnFootFoot";

    /**
     * Player's outcome on Football / Cinema.
     */
    String PARAM_PLAYER_OUTCOME_ON_FOOT_CIN = "PlayerOutcomeOnFootCin";

    @Override
    FzgGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
}