/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.tictactoe.gui.impl;

import de.fhdw.gaming.ipspiel23.tictactoe.core.domain.TicTacToeBoard;
import de.fhdw.gaming.ipspiel23.tictactoe.core.domain.TicTacToeField;
import de.fhdw.gaming.ipspiel23.tictactoe.core.domain.TicTacToeFieldState;
import de.fhdw.gaming.ipspiel23.tictactoe.core.domain.TicTacToePlayer;
import de.fhdw.gaming.ipspiel23.tictactoe.core.domain.TicTacToePosition;
import de.fhdw.gaming.ipspiel23.tictactoe.core.domain.TicTacToeState;
import de.fhdw.gaming.ipspiel23.tictactoe.gui.TicTacToeBoardEventProvider;
import de.fhdw.gaming.ipspiel23.tictactoe.gui.event.TicTacToeBoardEvent;
import de.fhdw.gaming.ipspiel23.tictactoe.gui.event.TicTacToeMakeMoveBoardEvent;
import de.fhdw.gaming.ipspiel23.tictactoe.gui.impl.TicTacToeBoardView;
import de.fhdw.gaming.ipspiel23.tictactoe.gui.impl.TicTacToeFieldView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.scene.Cursor;
import javafx.scene.input.MouseButton;

final class TicTacToeBoardEventProviderImpl
implements TicTacToeBoardEventProvider {
    private final TicTacToeBoardView boardView;

    TicTacToeBoardEventProviderImpl(TicTacToeBoardView boardView) {
        this.boardView = boardView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TicTacToeBoardEvent waitForEvent(TicTacToePlayer player, TicTacToeState state) {
        Runnable cleanUp;
        Object fieldViews;
        LinkedHashMap<TicTacToePosition, TicTacToeFieldView> emptyFieldViews = new LinkedHashMap<TicTacToePosition, TicTacToeFieldView>();
        for (Map.Entry entry : state.getBoard().getFieldsBeing(TicTacToeFieldState.EMPTY).entrySet()) {
            emptyFieldViews.put((TicTacToePosition)entry.getKey(), this.boardView.getFieldView((TicTacToePosition)entry.getKey()).orElseThrow());
        }
        AtomicReference<TicTacToeBoardEvent> event = new AtomicReference<TicTacToeBoardEvent>();
        if (emptyFieldViews.isEmpty()) {
            fieldViews = this.setupInactiveFields(state.getBoard());
            cleanUp = () -> this.cleanUpFields((Collection<? extends TicTacToeFieldView>)fieldViews);
        } else {
            this.setupActiveFields(emptyFieldViews, event);
            cleanUp = () -> this.cleanUpFields(emptyFieldViews.values());
        }
        try {
            this.boardView.getUserInputSemaphore().acquire();
            fieldViews = event.get();
            return fieldViews;
        }
        catch (InterruptedException e) {
            TicTacToeBoardEvent ticTacToeBoardEvent = null;
            return ticTacToeBoardEvent;
        }
        finally {
            Platform.runLater((Runnable)cleanUp);
        }
    }

    private void setupActiveFields(Map<TicTacToePosition, TicTacToeFieldView> emptyFieldViews, AtomicReference<TicTacToeBoardEvent> event) {
        for (Map.Entry<TicTacToePosition, TicTacToeFieldView> entry : emptyFieldViews.entrySet()) {
            TicTacToePosition position = entry.getKey();
            TicTacToeFieldView fieldView = entry.getValue();
            Platform.runLater(() -> {
                fieldView.setCursor(Cursor.CROSSHAIR);
                fieldView.setHighlighted(true);
                fieldView.setOnMouseClicked(mouseEvent -> {
                    if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                        event.set(new TicTacToeMakeMoveBoardEvent(position));
                        this.boardView.getUserInputSemaphore().release();
                    }
                });
            });
        }
    }

    private List<TicTacToeFieldView> setupInactiveFields(TicTacToeBoard board) {
        ArrayList fields = new ArrayList();
        board.getFields().forEach(list -> fields.addAll(list));
        ArrayList<TicTacToeFieldView> fieldViews = new ArrayList<TicTacToeFieldView>();
        for (TicTacToeField field : fields) {
            TicTacToeFieldView fieldView = this.boardView.getFieldView(field.getPosition()).orElseThrow();
            fieldViews.add(fieldView);
            Platform.runLater(() -> {
                fieldView.setCursor(Cursor.CLOSED_HAND);
                fieldView.setOnMouseClicked(null);
            });
        }
        return fieldViews;
    }

    private void cleanUpFields(Collection<? extends TicTacToeFieldView> fieldViews) {
        for (TicTacToeFieldView ticTacToeFieldView : fieldViews) {
            ticTacToeFieldView.setCursor(Cursor.DEFAULT);
            ticTacToeFieldView.setHighlighted(false);
            ticTacToeFieldView.setOnMouseClicked(null);
        }
    }

    @Override
    public void cancelWaiting() {
        this.boardView.getUserInputSemaphore().release();
    }
}

