/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.gststrategy;

import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4State;
import de.fhdw.gaming.ipspiel23.c4.gststrategy.SimpleC4GSTEvaluation;
import de.fhdw.gaming.ipspiel23.c4.moves.IC4Move;
import de.fhdw.gaming.ipspiel23.c4.moves.factory.IC4MoveFactory;
import de.fhdw.gaming.ipspiel23.gst.domain.IKopplung;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public class C4GSTKopplung
implements IKopplung<IC4Player, IC4State> {
    private final SimpleC4GSTEvaluation evaluationStrategy;
    private final IC4MoveFactory moveFactory;

    public C4GSTKopplung(IC4MoveFactory moveFactory) {
        this.moveFactory = moveFactory;
        this.evaluationStrategy = new SimpleC4GSTEvaluation();
    }

    public Optional<Collection<Move<IC4Player, IC4State>>> getPossibleMoves(IC4State state) {
        IC4Position[] positions = state.getBoard().getLegalPositions();
        ArrayList<IC4Move> possibleMoves = new ArrayList<IC4Move>();
        for (IC4Position position : positions) {
            possibleMoves.add(this.moveFactory.createMove(state.getCurrentPlayer(), position));
        }
        return Optional.of(possibleMoves);
    }

    public Optional<Integer> evalState(IC4State state) {
        return Optional.of(this.evaluationStrategy.evalC4State(state));
    }

    public Optional<IC4Player> getCurrentPlayer(IC4State state) {
        return Optional.of(state.getCurrentPlayer());
    }

    public Optional<Boolean> getIsGameOver(IC4State state) {
        return Optional.of(state.getPlayers().values().stream().filter(p -> p.getState() == PlayerState.PLAYING).findAny().isEmpty());
    }
}

