/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.ssp.strategy;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspPlayer;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspState;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspStrategy;
import de.fhdw.gaming.ipspiel23.ssp.moves.SspMove;
import de.fhdw.gaming.ipspiel23.ssp.moves.factory.SspMoveFactory;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;

public final class SspMixedStrategy
implements SspStrategy {
    private static final Random RANDOM = new Random();
    private final SspMoveFactory moveFactory;

    SspMixedStrategy(SspMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<SspMove> computeNextMove(int gameId, SspPlayer player, SspState state) throws GameException, InterruptedException {
        List<Supplier<SspMove>> moveSuppliers = List.of(this.moveFactory::createPaperMove, this.moveFactory::createScissorsMove, this.moveFactory::createStoneMove);
        return Optional.of(moveSuppliers.get(RANDOM.nextInt(moveSuppliers.size())).get());
    }

    public String toString() {
        return SspMixedStrategy.class.getSimpleName();
    }

    public boolean equals(Object obj) {
        return obj != null && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return super.hashCode() * this.toString().hashCode();
    }
}

