/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.ipspiel23.c4.collections.IReadOnlyDictionary;
import de.fhdw.gaming.ipspiel23.c4.collections.ReadOnlyDictionary;
import de.fhdw.gaming.ipspiel23.c4.domain.C4Direction;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Board;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4BoardSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Field;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Solution;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4FieldHeavy;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4SolutionHeavy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class C4BoardHeavy
implements IC4Board {
    private final IReadOnlyDictionary<Integer, IC4Player> players;
    private final int rowCount;
    private final int columnCount;
    private final int solutionSize;
    private final IC4Field[][] fields;

    public C4BoardHeavy(IReadOnlyDictionary<Integer, IC4Player> players, int rowCount, int columnCount, int solutionSize) {
        this.players = players;
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.solutionSize = solutionSize;
        this.fields = new IC4Field[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int column = 0; column < columnCount; ++column) {
                this.fields[row][column] = new C4FieldHeavy(this, new C4Position(row, column));
            }
        }
    }

    private C4BoardHeavy(C4BoardHeavy board) {
        HashMap<Integer, IC4Player> playerMap = new HashMap<Integer, IC4Player>();
        for (Integer key : board.players.getKeys()) {
            playerMap.put(key, board.players.getValueOrDefault(key));
        }
        this.players = ReadOnlyDictionary.of(playerMap);
        this.rowCount = board.rowCount;
        this.columnCount = board.columnCount;
        this.solutionSize = board.solutionSize;
        this.fields = new IC4Field[this.rowCount][this.columnCount];
        for (int row = 0; row < this.rowCount; ++row) {
            for (int column = 0; column < this.columnCount; ++column) {
                this.fields[row][column] = board.getField(new C4Position(row, column)).deepCopy();
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getMinimumSolutionSize() {
        return this.solutionSize;
    }

    @Override
    public boolean checkBounds(int row, int column) {
        return row >= 0 && row < this.rowCount && column >= 0 && column < this.columnCount;
    }

    @Override
    public boolean isFull() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                Optional<IC4Field> field = this.tryGetField(new C4Position(i, j));
                if (!field.get().getOccupyingPlayer().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public IC4BoardSlim getInternalBoard() {
        throw new UnsupportedOperationException("'getInternalBoard' is not supported by this implementation");
    }

    @Override
    public Optional<IC4Field> tryGetField(IC4Position position) {
        if (this.checkBounds(position)) {
            return Optional.of(this.fields[position.getRow()][position.getColumn()]);
        }
        return Optional.empty();
    }

    @Override
    public IC4Field getField(IC4Position position) {
        if (this.checkBounds(position)) {
            return this.tryGetField(position).get();
        }
        throw new IndexOutOfBoundsException("Position is out of bounds");
    }

    @Override
    public IC4Field[][] getFields() {
        IC4Field[][] copiedFields = new IC4Field[this.fields.length][];
        for (int i = 0; i < this.fields.length; ++i) {
            copiedFields[i] = (IC4Field[])this.fields[i].clone();
        }
        return copiedFields;
    }

    @Override
    public Optional<IC4Solution> tryFindFirstSolution() {
        Set<IC4Solution> solutions = this.findAllSolutionsInternal(false);
        if (solutions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(solutions.iterator().next());
    }

    @Override
    public Set<IC4Solution> findAllSolutions() {
        return this.findAllSolutionsInternal(true);
    }

    private Set<IC4Solution> findAllSolutionsInternal(boolean eagerEvaluation) {
        HashSet<IC4Solution> solutions = new HashSet<IC4Solution>();
        this.scanHorizontal(solutions, eagerEvaluation);
        this.scanVertical(solutions, eagerEvaluation);
        this.scanDiagonalLeft(solutions, eagerEvaluation);
        this.scanDiagonalRight(solutions, eagerEvaluation);
        return solutions;
    }

    private void scanHorizontal(Set<IC4Solution> solutions, boolean eagerEvaluation) {
        if (!eagerEvaluation && !solutions.isEmpty()) {
            return;
        }
        boolean foundSolution = false;
        for (int row = 0; row < this.getRowCount() && (!foundSolution || eagerEvaluation); ++row) {
            C4Position startPosition = new C4Position(row, 0);
            foundSolution = this.scanLane(solutions, startPosition, C4Direction.EAST, eagerEvaluation);
        }
    }

    private void scanVertical(Set<IC4Solution> solutions, boolean eagerEvaluation) {
        if (!eagerEvaluation && !solutions.isEmpty()) {
            return;
        }
        boolean foundSolution = false;
        for (int column = 0; column < this.getColumnCount() && (!foundSolution || eagerEvaluation); ++column) {
            C4Position startPosition = new C4Position(0, column);
            foundSolution = this.scanLane(solutions, startPosition, C4Direction.SOUTH, eagerEvaluation);
        }
    }

    private void scanDiagonalRight(Set<IC4Solution> solutions, boolean eagerEvaluation) {
        C4Position startPosition;
        if (!eagerEvaluation && !solutions.isEmpty()) {
            return;
        }
        boolean foundSolution = false;
        for (int row = 0; row < this.getRowCount() && (!foundSolution || eagerEvaluation); ++row) {
            startPosition = new C4Position(row, 0);
            foundSolution = this.scanLane(solutions, startPosition, C4Direction.SOUTH_EAST, eagerEvaluation);
        }
        for (int column = 1; column < this.getColumnCount() && (!foundSolution || eagerEvaluation); ++column) {
            startPosition = new C4Position(0, column);
            foundSolution = this.scanLane(solutions, startPosition, C4Direction.SOUTH_EAST, eagerEvaluation);
        }
    }

    private void scanDiagonalLeft(Set<IC4Solution> solutions, boolean eagerEvaluation) {
        C4Position startPosition;
        if (!eagerEvaluation && !solutions.isEmpty()) {
            return;
        }
        boolean foundSolution = false;
        for (int row = 0; row < this.getRowCount() && (!foundSolution || eagerEvaluation); ++row) {
            startPosition = new C4Position(row, this.getColumnCount() - 1);
            foundSolution = this.scanLane(solutions, startPosition, C4Direction.SOUTH_WEST, eagerEvaluation);
        }
        for (int column = 0; column < this.getColumnCount() - 1 && (!foundSolution || eagerEvaluation); ++column) {
            startPosition = new C4Position(0, column);
            foundSolution = this.scanLane(solutions, startPosition, C4Direction.SOUTH_WEST, eagerEvaluation);
        }
    }

    private boolean scanLane(Set<IC4Solution> solutions, IC4Position startPosition, C4Direction direction, boolean eagerEvaluation) {
        Optional<IC4Field> field;
        if (!eagerEvaluation && !solutions.isEmpty()) {
            return true;
        }
        Optional<Object> lastPlayer = Optional.empty();
        int lastPlayerCount = 0;
        IC4Position currentPosition = startPosition;
        while (!(field = this.tryGetField(currentPosition)).isEmpty()) {
            Optional<IC4Player> currentPlayer = field.get().getOccupyingPlayer();
            if (currentPlayer.isPresent()) {
                if (currentPlayer.equals(lastPlayer)) {
                    ++lastPlayerCount;
                } else {
                    lastPlayer = currentPlayer;
                    lastPlayerCount = 1;
                }
                if (lastPlayerCount >= this.solutionSize) {
                    IC4Solution solution = this.scanFullSolution(lastPlayerCount, (IC4Player)lastPlayer.get(), currentPosition, direction);
                    solutions.add(solution);
                    if (!eagerEvaluation) {
                        return true;
                    }
                }
            } else {
                lastPlayer = Optional.empty();
                lastPlayerCount = 0;
            }
            currentPosition = direction.stepFrom(currentPosition, 1);
        }
        return false;
    }

    private IC4Solution scanFullSolution(int currentCount, IC4Player player, IC4Position currentPosition, C4Direction direction) {
        int size = currentCount + this.scanRemaining(currentPosition, direction, player);
        IC4Field[] solutionFields = new IC4Field[size];
        IC4Position startPosition = direction.getInverse().stepFrom(currentPosition, currentCount - 1);
        for (int i = 0; i < size; ++i) {
            Optional<IC4Field> field = this.tryGetField(direction.stepFrom(startPosition, i));
            solutionFields[i] = field.get();
        }
        return new C4SolutionHeavy(player, startPosition, direction.stepFrom(startPosition, size - 1), direction, solutionFields);
    }

    private int scanRemaining(IC4Position position, C4Direction direction, IC4Player player) {
        Optional<IC4Player> fieldPlayer;
        Optional<IC4Field> currentField;
        int count = 0;
        IC4Position currentPosition = position;
        while (!(currentField = this.tryGetField(currentPosition = direction.stepFrom(currentPosition, 1))).isEmpty() && !currentField.get().getOccupyingPlayer().isEmpty() && !(fieldPlayer = currentField.get().getOccupyingPlayer()).isEmpty() && fieldPlayer.get().equals(player)) {
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty(IC4Position position) {
        return this.fields[position.getRow()][position.getColumn()].getOccupyingPlayer().isEmpty();
    }

    @Override
    public boolean isEmpty(int row, int column) {
        return this.isEmpty(new C4Position(row, column));
    }

    @Override
    public boolean checkBounds(IC4Position position) {
        return this.checkBounds(position.getRow(), position.getColumn());
    }

    @Override
    public boolean isSolid(IC4Position position) {
        if (!this.checkBounds(position) && !this.checkBounds(C4Direction.NORTH.stepFrom(position, 1))) {
            throw new IndexOutOfBoundsException("The provided position is not within the defined bounds of the board!");
        }
        Optional<IC4Field> field = this.tryGetField(position);
        if (field.isPresent()) {
            return field.get().getOccupyingPlayer().isPresent();
        }
        return this.tryGetField(C4Direction.NORTH.stepFrom(position, 1)).isPresent();
    }

    @Override
    public boolean isSolid(int row, int column) {
        return this.isSolid(new C4Position(row, column));
    }

    @Override
    public Optional<IC4Player> getOccupyingPlayerOrDefault(IC4Position position) {
        if (!this.checkBounds(position)) {
            throw new IndexOutOfBoundsException("The provided position is not within the defined bounds of the board!");
        }
        Optional<IC4Field> field = this.tryGetField(position);
        if (field.isPresent()) {
            return field.get().getOccupyingPlayer();
        }
        return Optional.empty();
    }

    @Override
    public IC4Position[] getEmptyPositions() {
        ArrayList<C4Position> emptyPositions = new ArrayList<C4Position>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column = 0; column < this.getColumnCount(); ++column) {
                C4Position position = new C4Position(row, column);
                if (!this.isEmpty(position)) continue;
                emptyPositions.add(position);
            }
        }
        return emptyPositions.toArray(new IC4Position[0]);
    }

    @Override
    public IC4Position[] getPositionsByPlayer(IC4Player player) {
        ArrayList<C4Position> positions = new ArrayList<C4Position>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column = 0; column < this.getColumnCount(); ++column) {
                C4Position position = new C4Position(row, column);
                Optional<IC4Player> occupyingPlayer = this.getOccupyingPlayerOrDefault(position);
                if (!occupyingPlayer.isPresent() || !occupyingPlayer.get().equals(player)) continue;
                positions.add(position);
            }
        }
        return positions.toArray(new IC4Position[0]);
    }

    @Override
    public IC4Position[] getLegalPositions() {
        ArrayList<C4Position> legalPositions = new ArrayList<C4Position>();
        boolean inAir = false;
        for (int column = 0; column < this.getColumnCount(); ++column) {
            int row;
            for (row = this.getRowCount() - 1; row >= 0 && !inAir; --row) {
                inAir = this.getField(new C4Position(row, column)).getOccupyingPlayer().isEmpty();
            }
            if (!inAir) continue;
            inAir = false;
            legalPositions.add(new C4Position(row + 1, column));
        }
        return legalPositions.toArray(new IC4Position[0]);
    }

    @Override
    public int countEmptyPositions() {
        return this.getEmptyPositions().length;
    }

    @Override
    public int countPositionsByPlayer(IC4Player player) {
        return this.getPositionsByPlayer(player).length;
    }

    @Override
    public int countLegalPositions() {
        return this.getLegalPositions().length;
    }

    @Override
    public IC4Board deepCopy() {
        return new C4BoardHeavy(this);
    }
}

