package de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation;

import de.fhdw.gaming.ipspiel23.c4.domain.C4Direction;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4BoardSlim;

/**
 * Analyzes all diagonal solutions of a board.
 */
public abstract class C4SolutionAnalyzerDiagonal extends C4SolutionAnalyzer {

    /**
     * Contains all positions that are not part of a solution.
     */
    private final boolean[] isBlacklisted;

    /**
     * Creates a new instance of {@link C4SolutionAnalyzerDiagonal}.
     * @param board The board to be analyzed.
     * @param searchDirection The search direction to be analyzed.
     */
    protected C4SolutionAnalyzerDiagonal(final C4BoardSlim board, final C4Direction searchDirection) {
        super(board, searchDirection);

        // viable rows = board.getRowCount() - board.getMinimumSolutionSize() + 1
        // viable columns = board.getColumnCount() - board.getMinimumSolutionSize()
        // one less column, because the corner diagonal is included in rows
        final int capacity = board.getRowCount() + board.getColumnCount() + 1 - 2 * board.getMinimumSolutionSize();
        isBlacklisted = new boolean[capacity];
    }

    /**
     * Indicates whether a position may be part of a solution.
     * @param index The index of the position.
     * @return Whether a position may be part of a solution.
     */
    public boolean mayContainSolution(final int index) {
        return !isBlacklisted[index];
    }

    /**
     * Marks a position to not be part of a solution.
     * @param index The index of the position.
     */
    public void noSolutionIn(final int index) {
        isBlacklisted[index] = true;
    }

    @Override
    public void resetCache() {
        for (int i = 0; i < isBlacklisted.length; i++) {
            isBlacklisted[i] = false;
        }
    }
}
