/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4MutablePlayerState;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4PlayerBuilder;
import de.fhdw.gaming.ipspiel23.c4.strategies.IC4Strategy;
import java.util.Optional;

public class C4Player
implements IC4Player {
    private final String name;
    private final int token;
    private final C4MutablePlayerState mutableState;
    private IC4Strategy strategy;

    C4Player(C4PlayerBuilder builder, int token, String name) {
        this.token = token;
        this.name = name;
        builder.setPlayerStrategyHook(newStrategy -> {
            this.strategy = newStrategy;
        });
        this.mutableState = new C4MutablePlayerState(PlayerState.PLAYING, null);
    }

    private C4Player(C4Player player) {
        this.token = player.token;
        this.name = player.name;
        this.mutableState = new C4MutablePlayerState(player.mutableState.getState(), player.mutableState.getOutcome().orElse(null));
        this.strategy = player.strategy;
    }

    public String getName() {
        return this.name;
    }

    public PlayerState getState() {
        return this.mutableState.getState();
    }

    public void setState(PlayerState newState) {
        this.mutableState.setState(newState);
    }

    public Optional<Double> getOutcome() {
        return this.mutableState.getOutcome();
    }

    public void setOutcome(double newOutcome) {
        this.mutableState.setOutcome(newOutcome);
    }

    @Override
    public IC4Player deepCopy() {
        return new C4Player(this);
    }

    @Override
    public int getToken() {
        return this.token;
    }

    @Override
    public IC4Strategy getStrategy() {
        if (this.strategy == null) {
            throw new IllegalStateException("The strategy of the player " + this.name + " was never set.");
        }
        return this.strategy;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof IC4Player)) {
            return false;
        }
        IC4Player otherPlayer = (IC4Player)other;
        return this.token == otherPlayer.getToken() && this.name.equals(otherPlayer.getName()) && this.getState() == otherPlayer.getState() && this.getOutcome().equals(otherPlayer.getOutcome()) && this.getStrategy().equals(otherPlayer.getStrategy());
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.token;
        hash = 31 * hash + this.name.hashCode();
        hash = 31 * hash + this.mutableState.hashCode();
        if (this.strategy != null) {
            hash = 31 * hash + this.strategy.hashCode();
        }
        return hash;
    }

    public String toString() {
        return "C4Player [name=" + this.name + ", token=" + this.token + ", state=" + this.getState() + ", outcome=" + this.getOutcome() + ", strategy=" + this.strategy + "]";
    }
}

