/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation;

import de.fhdw.gaming.ipspiel23.c4.domain.C4Direction;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4SolutionSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4BoardSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4SolutionSlim;
import java.util.Set;

public abstract class C4SolutionAnalyzer {
    private final C4Direction searchDirection;
    private final C4BoardSlim boardField;
    private final int rowMaxField;
    private final int colMaxField;
    private final int targetCountField;

    protected C4SolutionAnalyzer(C4BoardSlim board, C4Direction searchDirection) {
        this.searchDirection = searchDirection;
        this.boardField = board;
        this.rowMaxField = board.getRowCount();
        this.colMaxField = board.getColumnCount();
        this.targetCountField = board.getMinimumSolutionSize() - 1;
    }

    public abstract IC4SolutionSlim tryFindFirstSolution(IC4SolutionSlim var1, boolean var2);

    public abstract void findAllSolutions(Set<IC4SolutionSlim> var1, boolean var2);

    public C4Direction getSearchDirection() {
        return this.searchDirection;
    }

    protected C4BoardSlim board() {
        return this.boardField;
    }

    public abstract void resetCache();

    protected int rowMax() {
        return this.rowMaxField;
    }

    protected int colMax() {
        return this.colMaxField;
    }

    protected int targetCount() {
        return this.targetCountField;
    }

    protected C4SolutionSlim solutionOf(int token, int matchEndRow, int matchEndCol, int size) {
        return new C4SolutionSlim(this.boardField, token, matchEndRow, matchEndCol, this.searchDirection, size);
    }

    protected abstract C4SolutionSlim scanRemaining(int var1, int var2, int var3);

    protected static int countConsecutivesBranchless(int count, int token, int previousToken) {
        return 0 + (count + 1 & C4SolutionAnalyzer.areNotEqualMask(previousToken, 0) & C4SolutionAnalyzer.areEqualMask(token, previousToken));
    }

    protected static int areNotEqualMask(int value1, int value2) {
        return -(value1 ^ value2) >> 31;
    }

    protected static int areEqualMask(int value1, int value2) {
        return ~C4SolutionAnalyzer.areNotEqualMask(value1, value2);
    }
}

