/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation;

import de.fhdw.gaming.ipspiel23.c4.domain.C4Direction;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4SolutionSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4BoardSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4SolutionSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation.C4SolutionAnalyzer;
import java.util.Set;

public class C4SolutionAnalyzerHorizontal
extends C4SolutionAnalyzer {
    private int optimizedRowMax = super.rowMax();

    public C4SolutionAnalyzerHorizontal(C4BoardSlim board) {
        super(board, C4Direction.EAST);
    }

    @Override
    public IC4SolutionSlim tryFindFirstSolution(IC4SolutionSlim currentSolution, boolean updateCache) {
        if (currentSolution != null) {
            return currentSolution;
        }
        boolean isRowEmpty = false;
        for (int row = this.optimizedRowMax - 1; row >= 0 && !isRowEmpty; --row) {
            int lastToken = 0;
            int count = 0;
            isRowEmpty = true;
            boolean isRowFull = true;
            for (int col = 0; col < this.colMax(); ++col) {
                int token = this.board().getTokenUnsafe(row, col);
                if ((count = C4SolutionAnalyzerHorizontal.countConsecutivesBranchless(count, token, lastToken)) >= this.targetCount()) {
                    return this.scanRemaining(token, row, col);
                }
                isRowFull &= token != 0;
                isRowEmpty &= token == 0;
                lastToken = token;
            }
            if (!updateCache || !isRowFull) continue;
            this.optimizedRowMax = row;
        }
        return null;
    }

    @Override
    public void findAllSolutions(Set<IC4SolutionSlim> resultSet, boolean updateCache) {
        boolean isRowEmpty = false;
        for (int row = this.optimizedRowMax - 1; row >= 0 && !isRowEmpty; --row) {
            isRowEmpty = true;
            int lastToken = 0;
            int count = 0;
            boolean isRowFull = true;
            boolean rowContainsSolution = false;
            for (int col = 0; col < this.colMax(); ++col) {
                int token = this.board().getTokenUnsafe(row, col);
                if ((count = C4SolutionAnalyzerHorizontal.countConsecutivesBranchless(count, token, lastToken)) >= this.targetCount()) {
                    count = 0;
                    C4SolutionSlim solution = this.scanRemaining(token, row, col);
                    resultSet.add(solution);
                    rowContainsSolution = true;
                    col = solution.getColumnIndexEnd();
                }
                isRowFull &= token != 0;
                isRowEmpty &= token == 0;
                lastToken = token;
            }
            if (!updateCache || !isRowFull || rowContainsSolution) continue;
            this.optimizedRowMax = row;
        }
    }

    @Override
    protected C4SolutionSlim scanRemaining(int token, int startRow, int startCol) {
        int col;
        for (col = startCol + 1; col < this.colMax() && this.board().getTokenUnsafe(startRow, col) == token; ++col) {
        }
        return this.solutionOf(token, startRow, --col, this.board().getMinimumSolutionSize() + col - startCol);
    }

    @Override
    public void resetCache() {
        this.optimizedRowMax = super.rowMax();
    }
}

