/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.ipspiel23.c4.domain.C4Direction;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Board;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4BoardSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Field;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4Board;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4Position;
import java.util.Map;
import java.util.Optional;

public class C4Field
implements IC4Field {
    private final C4Board board;
    private final int row;
    private final int column;
    private IC4Position position;

    public C4Field(C4Board board, int row, int column) {
        this.board = board;
        this.row = row;
        this.column = column;
    }

    public C4Field(C4Board board, IC4Position position) {
        this(board, position.getRow(), position.getColumn());
        this.position = position;
    }

    @Override
    public IC4Board getBoard() {
        return this.board;
    }

    @Override
    public IC4Position getBoardPosition() {
        if (this.position == null) {
            this.position = new C4Position(this.row, this.column);
        }
        return this.position;
    }

    @Override
    public Optional<IC4Player> getOccupyingPlayer() {
        IC4BoardSlim slimBoard = this.board.getInternalBoard();
        int token = slimBoard.getTokenUnsafe(this.row, this.column);
        if (token == slimBoard.emptyToken()) {
            return Optional.empty();
        }
        return Optional.of(slimBoard.getPlayerByToken(token));
    }

    @Override
    public boolean trySetOccupyingPlayer(IC4Player player, boolean allowOverride) {
        IC4BoardSlim slimBoard = this.board.getInternalBoard();
        int token = slimBoard.getTokenUnsafe(this.row, this.column);
        if (!allowOverride && token != slimBoard.emptyToken()) {
            return false;
        }
        int rowBeneath = this.row + 1;
        if (slimBoard.isSolidUnsafe(rowBeneath, this.column)) {
            slimBoard.updateTokenUnsafe(this.row, this.column, player.getToken());
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNeighbor(C4Direction direction) {
        IC4Position neighborPosition = direction.stepFrom(this.getBoardPosition(), 1);
        return this.board.getInternalBoard().checkBounds(neighborPosition.getRow(), neighborPosition.getColumn());
    }

    @Override
    public IC4Field getNeighbor(C4Direction direction) {
        return this.getNeighborInternal(direction, true);
    }

    @Override
    public Optional<IC4Field> tryGetNeighbor(C4Direction direction) {
        IC4Field neighbor = this.getNeighborInternal(direction, false);
        return Optional.ofNullable(neighbor);
    }

    private IC4Field getNeighborInternal(C4Direction direction, boolean throwOob) {
        IC4Position neighborPosition = direction.stepFrom(this.getBoardPosition(), 1);
        Map<IC4Position, IC4Field> fieldCache = this.board.getFieldCache();
        IC4Field neighbor = fieldCache.get(neighborPosition);
        if (neighbor != null) {
            return neighbor;
        }
        if (!this.board.checkBounds(neighborPosition.getRow(), neighborPosition.getColumn())) {
            if (throwOob) {
                throw new IndexOutOfBoundsException("The provided direction violates the bounds of the game board.");
            }
            return null;
        }
        neighbor = new C4Field(this.board, neighborPosition);
        fieldCache.put(neighborPosition, neighbor);
        return neighbor;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IC4Field)) {
            return false;
        }
        IC4Field other = (IC4Field)obj;
        return this.getBoardPosition().equals(other.getBoardPosition()) && this.getBoard().equals(other.getBoard());
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + this.getBoardPosition().hashCode();
        hash = hash * 31 + this.getBoard().hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("C4Field[player=").append(this.getOccupyingPlayer().map(Player::getName).orElse("empty")).append(", position=").append(this.getBoardPosition()).append(']');
        return sb.toString();
    }

    @Override
    public IC4Field deepCopy() {
        return new C4Field(this.board, this.row, this.column);
    }
}

