package de.fhdw.gaming.ipspiel23.c4.domain.impl.validation;

import java.util.function.Consumer;

import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.Validator;

/**
 * Validates and stores user-supplied values against a shared instances of {@link C4BoardLimits}
 * in order to handle cross dependencies between the different allowed board settings.
 */
public final class C4BoardValidator implements Validator<Integer> {

    /**
     * The limits to validate against.
     */
    private final C4BoardLimits state;

    /**
     * The action to execute when the validator is called.
     */
    private final Consumer<C4BoardValidationStateUpdateContext> updateAction;

    /**
     * The update context to use when the validator is called.
     */
    private final C4BoardValidationStateUpdateContext updateContext;

    /**
     * The info to display when the validator is called.
     */
    private final C4BoardValidatorInfo info;

    /**
     * Creates a new instance of {@link C4BoardValidator}.
     * 
     * @param state The limits to validate against.
     * @param updateAction The action used to update the validation state.
     * @param info The info to display when the validator is called.
     */
    public C4BoardValidator(final C4BoardLimits state, 
            final Consumer<C4BoardValidationStateUpdateContext> updateAction, 
            final C4BoardValidatorInfo info) {
        this.updateAction = updateAction;
        this.state = state;
        this.updateContext = new C4BoardValidationStateUpdateContext(state, 0);
        this.info = info;
    }

    @Override
    public Integer validate(final Integer value) throws InputProviderException {
        this.updateContext.setValue(value);
        this.updateAction.accept(this.updateContext);
        this.state.assertIsValid();
        return value;
    }

    @Override
    public String getInfo() {
        return this.info.toInfoString(this.state.getPlayerCount());
    }
}
