package de.fhdw.gaming.ipspiel23.c4.domain;

import de.fhdw.gaming.core.domain.State;

/**
 * The state of the connect four game.
 */
public interface IC4State extends State<IC4Player, IC4State> {

    /**
     * The board of the connect four game.
     */
    IC4Board getBoard();

    /**
     * The player who is currently on turn.
     */
    IC4Player getCurrentPlayer();

    /**
     * A callback that is called when a move has been completed.
     */
    void onMoveCompleted();
}
