package de.fhdw.gaming.ipspiel23.c4.domain;

import de.fhdw.gaming.core.domain.Stateful;

/**
 * Represents any connect four board.
 */
public interface IC4BoardBase extends Stateful {

    /**
     * Retrieves the number of rows of the board.
     */
    int getRowCount();

    /**
     * Retrieves the number of columns of the board.
     */
    int getColumnCount();

    /**
     * Retrieves the minimum number of fields that are required to win the game.
     */
    int getMinimumSolutionSize();

    /**
     * Determines whether the specified position lies within the bounds of the board.
     * @param row The row of the position.
     * @param column The column of the position.
     * @return {@code true} if the position lies within the bounds of the board, {@code false} otherwise.
     */
    boolean checkBounds(int row, int column);

    /**
     * Checks whether the board is full, i.e. there are no empty positions left and no more tokens can be placed.
     * @return true if the board is full, false otherwise
     */
    boolean isFull();
}
