package de.fhdw.gaming.ipspiel23.c4.domain.impl.validation;

import de.fhdw.gaming.core.ui.InputProviderException;

import static de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits.MIN_COLUMN_COUNT;
import static de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits.MIN_ROW_COUNT;
import static de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits.MAX_COLUMN_COUNT;
import static de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits.MAX_ROW_COUNT;

/**
 * The dimensions of a board, to be used for validation.
 */
class C4BoardDimensions {
    /**
     * The currently specified number of rows a board will have.
     */
    private int rowCount;

    /**
     * The currently specified number of columns a board will have.
     */
    private int columnCount;

    /**
     * Creates a new instance of {@link C4BoardDimensions}.
     * 
     * @param rowCount The currently specified number of rows a board will have.
     * @param columnCount The currently specified number of columns a board will have.
     */
    public C4BoardDimensions(final int rowCount, final int columnCount) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
    }

    /**
     * Gets the currently specified number of rows a board will have.
     */
    public int getRowCount() {
        return rowCount;
    }

    /**
     * Sets the currently specified number of rows a board will have.
     * @param rowCount the new row count
     */
    public void setRowCount(final int rowCount) {
        this.rowCount = rowCount;
    }

    /**
     * Gets the currently specified number of columns a board will have.
     */
    public int getColumnCount() {
        return columnCount;
    }

    /**
     * Sets the currently specified number of columns a board will have.
     * @param columnCount the new column count
     */
    public void setColumnCount(final int columnCount) {
        this.columnCount = columnCount;
    }

    /**
     * Asserts that the currently specified number of rows and columns is valid.
     * @throws InputProviderException if the currently specified number of rows or columns is invalid
     */
    public void assertStaticLimits() throws InputProviderException {
        if (this.rowCount < MIN_ROW_COUNT) {
            throw new InputProviderException("The specified number of rows is too small: the number of rows "
                + "must be at least " + MIN_ROW_COUNT + ".");
        }
        if (this.columnCount < MIN_COLUMN_COUNT) {
            throw new InputProviderException("The specified number of columns is too small: the number of columns "
                + "must be at least " + MIN_COLUMN_COUNT + ".");
        }
        if (this.rowCount > MAX_ROW_COUNT) {
            throw new InputProviderException("The specified number of rows is too large: the number of rows "
                + "must not exceed " + MAX_ROW_COUNT + ".");
        }
        if (this.columnCount > MAX_COLUMN_COUNT) {
            throw new InputProviderException("The specified number of columns is too large: the number of columns "
                + "must not exceed " + MAX_COLUMN_COUNT + ".");
        }
    }

    @Override
    public boolean equals(final Object object) {
        if (object == null) {
            return false;
        } 
        if (!(object instanceof C4BoardDimensions)) {
            return false;
        }
        final C4BoardDimensions other = (C4BoardDimensions) object;
        return rowCount == other.rowCount && columnCount == other.columnCount;
    }

    @Override
    public int hashCode() {
        return rowCount * 31 + columnCount;
    }
}
