package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.probability;

import java.util.Optional;
import java.util.Random;

import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaStrategy;

/**
 * Implements {@link IDilemmaStrategy} by cooperating with a fixed probability.
 */
public class DilemmaProbabilityStrategy extends DilemmaStrategy {

    /**
     * Fixed probability with which this strategy cooperates.
     */
    static final double PROBABILITY_FOR_COOPERATION = 0.75d;
    
    /**
     * A portal to the realm of entropy and unexpectedness.
     */
    private static final Random RANDOM = new Random();

    /**
     * Creates an {@link DilemmaCooperateStrategy}.
     *
     * @param moveFactory The factory for creating Dilemma moves.
     */
    DilemmaProbabilityStrategy(final IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }
    
    @Override
    public Optional<IDilemmaMove> computeNextMove(final int gameId,
            final IDilemmaPlayer player,
            final IDilemmaState state) {
        return Optional.of(RANDOM.nextDouble() <= PROBABILITY_FOR_COOPERATION
            ? getMoveFactory().createCooperateMove()
            : getMoveFactory().createDefectMove());
    }

    @Override
    public String toString() {
        return DilemmaProbabilityStrategy.class.getSimpleName();
    }

    @Override
    public boolean equals(final Object object) {
        if (object instanceof DilemmaProbabilityStrategy) {
            final DilemmaProbabilityStrategy probabilityStrategy = (DilemmaProbabilityStrategy) object;
            return this.toString().equals(probabilityStrategy.toString());
        } else {
            return false;
        }
    }
    
    @Override
    public int hashCode() {
        return super.hashCode() * this.toString().hashCode();
    }
}