package de.fhdw.gaming.ipspiel23.dilemma.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

/**
 * Implements {@link IDilemmaStrategyFactoryProvider} by using the {@link ServiceLoader}.
 */
public final class DilemmaDefaultStrategyFactoryProvider implements IDilemmaStrategyFactoryProvider {

    @Override
    public List<IDilemmaStrategyFactory> getStrategyFactories() {
        final ServiceLoader<IDilemmaStrategyFactory> services = ServiceLoader.load(IDilemmaStrategyFactory.class);
        final List<IDilemmaStrategyFactory> list = new ArrayList<>();
        services.iterator().forEachRemaining(list::add);
        return list;
    }
}
