package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.discriminating_altruist;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaMemoryStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.cooperate.DilemmaCooperateStrategy;
import de.fhdw.gaming.ipspiel23.memory.GameMemoryCapacity;
import de.fhdw.gaming.ipspiel23.memory.IGameMemory;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryCapacity;

/**
 * This strategy is a variant of the {@link DilemmaCooperateStrategy} that
 * discriminates against opponents that have defected in the past.
 * 
 * It does so by refusing to engage with opponents that have defected in the
 * past. So it basically just becomes upset and doesn't want to play anymore.
 * Poor thing.
 */
public class DilemmaDiscriminatingAltruistStrategy extends DilemmaMemoryStrategy {

    /**
     * Creates a new instance of the {@link DilemmaDiscriminatingAltruistStrategy} class.
     * 
     * @param moveFactory the move factory to use
     */
    protected DilemmaDiscriminatingAltruistStrategy(final IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    @Override
    public Optional<IDilemmaMove> computeNextMove(final int gameId, final IDilemmaPlayer player, 
            final IDilemmaState state)
            throws GameException, InterruptedException {
        final IGameMemory<DilemmaRoundData> memory = getMemoryForPlayer(player, state);
        final IDilemmaMoveFactory moveFactory = getMoveFactory();

        int index;
        // check enire history for defect of opponent
        // maybe for some reason we didn't start out using DA strategy?
        for (index = 0; index < memory.size() && memory
            .getRound(index)
            .forOpponentOf(player)
            .answer().equals(DilemmaAnswerType.COOPERATE);) { 
                // pretty ugly, but PMD didn't like the empty for loop :P
                index++; 
            }
        
        if (index >= memory.size()) {
            // our opponent always cooperated :)
            return Optional.of(moveFactory.createCooperateMove());
        }
        // refuse to engage/do anything
        // basically give up :P
        // also: what does this even mean? 
        // if you're not saying anything isn't that technically cooperating? 
        return Optional.empty();
    }
    
    @Override
    protected IGameMemoryCapacity requestedMemoryCapacity() {
        return GameMemoryCapacity.unlimited();
    }
}
