package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.tit_for_two_tats;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaMemoryStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.memory.GameMemoryCapacity;
import de.fhdw.gaming.ipspiel23.memory.IGameMemory;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryCapacity;

import static de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType.DEFECT;
/**
 * Cooperates unless defected against twice in a row.
 */
public class DilemmaTitForTwoTatsStrategy extends DilemmaMemoryStrategy {

    /**
     * Creates a new instance of the {@link DilemmaTitForTwoTatsStrategy} class.
     * @param moveFactory the move factory to use.
     */
    protected DilemmaTitForTwoTatsStrategy(final IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    @Override
    public Optional<IDilemmaMove> computeNextMove(final int gameId, final IDilemmaPlayer player, 
            final IDilemmaState state)
            throws GameException, InterruptedException {
        final IGameMemory<DilemmaRoundData> memory = getMemoryForPlayer(player, state);
        final IDilemmaMoveFactory moveFactory = getMoveFactory();
        // always cooperate on first two rounds
        if (memory.size() == 0) {
            return Optional.of(moveFactory.createCooperateMove());
        }
        final DilemmaRoundData previousRound = memory.getRound(0, true);
        // ...and check if the opponent defects two times in a row
        if (previousRound.forOpponentOf(player).answer().equals(DEFECT) 
            && memory.size() > 1
            && memory.getRound(1, true).forOpponentOf(player).answer().equals(DEFECT)) {
            return Optional.of(moveFactory.createDefectMove());
        } else {
            return Optional.of(moveFactory.createCooperateMove());
        }
    }

    @Override
    protected IGameMemoryCapacity requestedMemoryCapacity() {
        return GameMemoryCapacity.unlimited();
    }
}
