package de.fhdw.gaming.ipspiel23.dilemma.utils;

/**
 * A factory for creating {@link ByRef} instances.
 */
public final class MakeRef {

    /**
     * unused utility class ctor.
     */
    private MakeRef() { }
    
    /**
     * Creates a new {@link ByRef} instance with the provided value ({@code ref} parameter in C#).
     * @param <T> The type of the referenced value.
     * @param value The initial value of the reference.
     * @return The created {@link ByRef} instance.
     */
    public static <T> ByRef<T> of(final T value) {
        return new ByRef<T>(value);
    }

    /**
     * Creates a new empty {@link ByRef} instance ({@code out} parameter in C#).
     * @param <T> The type of the referenced value.
     * @return The created {@link ByRef} instance.
     */
    public static <T> ByRef<T> empty() {
        return of(null);
    }
}