package de.fhdw.gaming.ipspiel23.dilemma.domain;

import java.util.Map;
import java.util.Optional;
import de.fhdw.gaming.core.domain.Player;

/**
 * Represents a Dilemma player.
 */
public interface IDilemmaPlayer extends Player<IDilemmaPlayer> {

    /**
     * Returns the possible outcomes of this player. The key for the first-level map is the answer of the first player,
     * the key for the second-level map is the answer of the second player.
     */
    Map<DilemmaAnswerType, Map<DilemmaAnswerType, Double>> getPossibleOutcomes();

    /**
     * Returns the answer of this player.
     */
    Optional<DilemmaAnswerType> getAnswer();

    /**
     * Sets the answer of this player.
     *
     * @param newAnswer The answer to set. {@code true} means "defect", {@code false} means "cooperate"
     * @throws IllegalStateException if an answer has already been set.
     */
    void setAnswer(DilemmaAnswerType newAnswer);

    /**
     * The strategy used by this player.
     */
    IDilemmaStrategy getStrategy();

    @Override
    IDilemmaPlayer deepCopy();
}
